#ifndef _MATHLIB_H_
#define _MATHLIB_H_

//~~~~~~~~~~~~~~~~~~~~~~
#include <QD_Types.h>
//~~~~~~~~~~~~~~~~~~~~~~



//---------------------------------------
#define PI    3.1415926535897932384626
#define TMathLibrary TMath
//---------------------------------------




//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                                TMathLibrary
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
class TMath
{
public:

  //*** Customized Methods
  //
  static INT32 Round          ( double d );
  static INT32 RoundUp        ( double d );
  static INT32 RoundEven      ( double d );
  static INT32 LeftMostOne    ( INT32 n );
  static INT32 LeftMostOnly   ( INT32 n );
  static bool  IntegerPowerTwo( INT32 n );
  static bool  DoubleInvalid  ( double d );
  static INT32 CheckSum       ( void *p, INT32 bits );   // checksum.asm
  static INT32 TimesDivide    ( INT32 n1, INT32 n2, INT32 d );

  static void IEEEtoTMS340( double ieee, char* tms340 );
  static void ChopDouble  ( char* d, INT32 ieee, char* ss, INT32* ee, long double* mm );
  
  //*** Standard Math Function Wrappers: <math.h>
  //
  static double AToFloat   ( const char* s );
  static INT32  AToInt32   ( const char* s );
  static INT32  StrToInt32 ( const char* s, char** endptr, INT32 radix );
  static UINT32 StrToUint32( const char* s, char** endptr, INT32 radix );
  //
  static INT32  Abs  ( INT32 x );
  //
  static double Acos ( double x );
  static double Asin ( double x );
  static double Atan ( double x );
  static double Atan2( double y, double x );
  static double Cos  ( double x );
  static double Sin  ( double x );
  static double Tan  ( double x );
  static double Cosh ( double x );
  static double Sinh ( double x );
  static double Tanh ( double x );
  static double Exp  ( double x );
  static double Frexp( double x, int* exponent );
  static double Ldexp( double x, int exp );
  static double Log  ( double x );
  static double Log10( double x );
  static double Modf ( double x, double* ipart );
  static double Pow  ( double x, double y );
  static double Sqrt ( double x );
  static double Ceil ( double x );
  static double Fabs ( double x );
  static double Floor( double x );
  static double Fmod ( double x, double y );

};



#endif
